cronjobs.controllers.module('configuration_modal', ['xhr'], () => {
    return {
        vue: true,
        name: 'gx-cronjobs-configuration-modal',
        parent: 'gx-cronjobs-overview',
        template: '#cronjobs-configuration-modal',
        props: {
            cronjob: {
                required: true,
                type: Object
            }
        },
        data: () => ({
            lang: {
                title_configuration_modal: jse.core.lang.translate('title_configuration_modal', 'cronjobs'),
                button_close: jse.core.lang.translate('BUTTON_CLOSE', 'admin_buttons'),
                button_save: jse.core.lang.translate('BUTTON_SAVE', 'admin_buttons')
            },
            inProcess: false
        }),
        watch: {
            cronjob(cronjob) {
                const $configurationModal = $('.configuration');

                if (Object.keys(cronjob).length > 0) {
                    $configurationModal.modal('show');
                    return;
                }
            }
        },
        methods: {
            getPhrase(title) {

                console.log(title);

                const phraseSection = title.split('.');
                const section = phraseSection[0];
                const phrase = phraseSection[1];

                return jse.core.lang.translate(phrase, section);
            },
            getConfigurationTitle(cronjob) {
                if (undefined === cronjob.name) {
                    return '';
                }
                const section = 'cronjob_' + this.camelToSnake(cronjob.name);

                return jse.core.lang.translate('configuration', section);
            },
            camelToSnake(string) {
                const upperChars = string.match(/([A-Z])/g);
                if (!upperChars) {
                    return string;
                }

                let str = string.toString();
                for (let i = 0, n = upperChars.length; i < n; i++) {
                    str = str.replace(new RegExp(upperChars[i]), '_' + upperChars[i].toLowerCase());
                }

                if (str.slice(0, 1) === '_') {
                    str = str.slice(1);
                }

                return str;
            },
            saveConfiguration() {
                const vm = this;
                const config = this.cronjob.configuration;
                const data = {};
                vm.inProcess = true;

                for (let i = 0, n = config.length; i < n; i++) {
                    if (config[i].type !== 'hidden') {
                        data[config[i].name] = config[i].value;
                    }
                }

                jse.libs.xhr.post({
                    url: './admin.php?do=CronjobAjax/saveConfiguration&task=' + this.cronjob.name,
                    data: data
                }, true).done(r => {
                    if (r.success) {
                        const $configurationModal = $('.configuration');

                        vm.$emit('updated');
                        vm.inProcess = false;
                        $configurationModal.modal('hide');
                    }
                }).fail(r => console.error(r));

            }
        },
        init: done => done()
    }
});